unit UFRMCADCONTATOS;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Mask, DBCtrls, Grids, DBGrids, Buttons, DB, ComCtrls, Comobj;

type
  TFRMCADCONTATOS = class(TForm)
    pneltitulo: TPanel;
    pnelconf: TPanel;
    pnelbotoes: TPanel;
    btnIncluir: TBitBtn;
    btnAlterar: TBitBtn;
    btnExcluir: TBitBtn;
    btnpesquisar: TBitBtn;
    dsPesquisar: TDataSource;
    btnpesquisa: TBitBtn;
    btngravar: TBitBtn;
    btnabortar: TBitBtn;
    btnsair: TBitBtn;
    spdbtnfirst: TSpeedButton;
    spdbtnprior: TSpeedButton;
    spdbtnnext: TSpeedButton;
    spdbtnlast: TSpeedButton;
    pneldados: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label11: TLabel;
    codigo: TDBEdit;
    nome: TDBEdit;
    template: TDBMemo;
    grupo1: TGroupBox;
    pnelgrade1: TPanel;
    grade1: TDBGrid;
    BtnRegister: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    procedure TravaControles;
    procedure DesTravaControles;
    procedure TravaPesquisa;
    procedure DestravaPesquisa;
    procedure Puxadados;
    procedure FormShow(Sender: TObject);
    procedure btnIncluirClick(Sender: TObject);
    procedure btnAlterarClick(Sender: TObject);
    procedure btnExcluirClick(Sender: TObject);
    procedure btnpesquisarClick(Sender: TObject);
    procedure btnpesquisaClick(Sender: TObject);
    procedure btngravarClick(Sender: TObject);
    procedure btnabortarClick(Sender: TObject);
    procedure btnsairClick(Sender: TObject);
    procedure spdbtnfirstClick(Sender: TObject);
    procedure spdbtnpriorClick(Sender: TObject);
    procedure spdbtnnextClick(Sender: TObject);
    procedure spdbtnlastClick(Sender: TObject);
    procedure BtnRegisterClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
        NBioAPIERROR_NONE = 0;
        NBioAPI_FIR_PURPOSE_VERIFY      = 1;
        //Constant for DeviceID
        NBioAPI_DEVICE_ID_NONE          = 0;
        NBioAPI_DEVICE_ID_FDP02_0       = 1;
        NBioAPI_DEVICE_ID_FDU01_0       = 2;
        NBioAPI_DEVICE_ID_AUTO_DETECT   = 255;

var
        FRMCADCONTATOS: TFRMCADCONTATOS;
        objNBioBSP      : variant;
        objDevice       : variant;
        objExtraction   : variant;
        objIndexSearch  : variant;

implementation

uses Nitgen_Con;

{$R *.dfm}

procedure TFrmCadContatos.Puxadados;
var
   vcod,vnome,vtemplate:string;
begin
   vcod:=codigo.text;
   vnome:=nome.text;

   vtemplate:=template.text;
end;


procedure TFrmCadContatos.TravaControles;
begin
     pneldados.enabled:=false;
     pnelbotoes.enabled:=true;
     pnelbotoes.visible:=true;
     pnelconf.enabled:=false;
     pnelconf.visible:=false;
     btnregister.Enabled:=false;
end;

procedure TFrmCadContatos.DesTravaControles;
begin
     pneldados.enabled:=true;
     pnelbotoes.enabled:=false;
     pnelbotoes.visible:=false;
     pnelconf.enabled:=true;
     pnelconf.visible:=true;
     btnregister.Enabled:=true;
end;

procedure TFrmCadContatos.TravaPesquisa;
begin
     btnpesquisar.enabled:=false;
     btnpesquisar.Visible:=false;
end;

procedure TFrmCadContatos.DesTravaPesquisa;
begin
     pneltitulo.caption:='';
     btnpesquisar.enabled:=true;
     btnpesquisar.Visible:=true;
end;



procedure TFRMCADCONTATOS.FormShow(Sender: TObject);
var
   i: integer;
   vcodigo: integer;
   vLastcodigo : integer;
   vtemplate: wideString;

begin
     //Create NBioBSP object
        objNBioBSP := CreateOleObject('NBioBSPCOM.NBioBSP');
        objDevice      := objNBioBSP.Device;
        objExtraction  := objNBioBSP.Extraction;
        objIndexSearch := objNBioBSP.IndexSearch;
        Caption := Caption + ' - BSP Version : v' + objNBioBSP.MajorVersion + '.' + objNBioBSP.MinorVersion;

    i:=0;
    dmdados.adotbcontatos.open;
    dmdados.adotbcontatos.last;
    vLastcodigo:=dmdados.adotbcontatos.fieldbyname('codigo').asinteger;

    dmdados.adotbcontatos.first;
    // Carrega na engine (memria) os dados ID e TEMPLATE dos usurios a partir do DataBase
    while (i<>vLastcodigo) do
    begin
      vtemplate:=dmdados.adotbcontatos.fieldbyname('observacoes').asstring;
      vcodigo:=dmdados.adotbcontatos.fieldbyname('codigo').asinteger;
      objIndexSearch.AddFIR(vtemplate, vcodigo);
      dmdados.adotbcontatos.next;
      i:=i+1;
    end;
    // Pop Up em Portugus.
    objNBioBSP.SetSkinResource ('.\NBSP2Por.dll');
    TravaControles;
    TravaPesquisa;
end;

procedure TFRMCADCONTATOS.btnIncluirClick(Sender: TObject);
var
   vcodigo: integer;
begin
   destravacontroles;

   dmdados.adotbcontatos.open;
   dmdados.adotbcontatos.last;
   vcodigo:=dmdados.adotbcontatos.fieldbyname('codigo').asinteger+1;

   dmdados.adotbcontatos.append;
   codigo.text:=inttostr(vcodigo);
   nome.setfocus;
end;

procedure TFRMCADCONTATOS.btnAlterarClick(Sender: TObject);
begin
     if dmdados.adotbcontatos.recordcount=0 then
        begin
           application.messagebox('No existem contatos a serem alterados'+#13'pois o arquivo est vazio','Arquivo de Contatos Vazio',+mb_iconerror);
           travacontroles;
        end
     else
        begin
           destravacontroles;
           dmdados.adotbcontatos.Edit;
           nome.setfocus;
        end;
end;

procedure TFRMCADCONTATOS.btnExcluirClick(Sender: TObject);
begin
     if dmdados.adotbcontatos.recordcount=0 then
        begin
           application.messagebox('No existem contatos a serem excludos'+#13'pois o arquivo est vazio','Arquivo de Contatos Vazio',+mb_iconerror);
        end
     else if application.MessageBox('Confirma Excluso ???','Excluir Contato',+mb_yesno+mb_iconquestion)=idyes then
             begin
                dmdados.adotbcontatos.Delete;
             end;
end;

procedure TFRMCADCONTATOS.btnpesquisarClick(Sender: TObject);
var
   userId,vcampo   : string;
   szFir    : wideString;
   str      : wideString;
begin
      vcampo:='codigo';
    // Abre o sensor
      objDevice.Open(NBioAPI_DEVICE_ID_AUTO_DETECT) ;
        if objDevice.ErrorCode <> NBioAPIERROR_NONE then
        begin
                str := objDevice.ErrorDescription;
                ShowMessage('Falha ao fazer a captura!');
                Exit;
        end;
    // Faz a captura
        objExtraction.Capture(NBioAPI_FIR_PURPOSE_VERIFY);
        if objExtraction.ErrorCode = NBioAPIERROR_NONE then
        begin
                // Fecha o sensor
                objDevice.Close(NBioAPI_DEVICE_ID_AUTO_DETECT);
                // szFir recebe o TEMPLATE
                szFir := objExtraction.TextEncodeFIR;

                //Faz a busca no IndexSearch com nvel de segurana 5
                objIndexSearch.IdentifyUser(szFir, 5);

                if objIndexSearch.ErrorCode <> NBioAPIERROR_NONE then
                begin
                        ShowMessage('Usurio no identificado!');
                        Exit;
                end;
                // Retorna o Id do usurio identificado
                userId := intTostr(objIndexSearch.UserID);
        end else
                ShowMessage('Extraction failed !');
         // Fecha o sensor
         objDevice.Close(NBioAPI_DEVICE_ID_AUTO_DETECT);



      if  dmdados.adotbcontatos.Locate(vcampo,userId,[locaseinsensitive, lopartialkey]) then
          begin
             PuxaDados;
             TravaPesquisa;
          end
      else
          begin
             application.MessageBox('Contato no encontrado !!!!','Resultado da pesquisa',+mb_iconerror);
             TravaPesquisa;
          end;


end;

procedure TFRMCADCONTATOS.btnpesquisaClick(Sender: TObject);
begin
    destravapesquisa;
end;

procedure TFRMCADCONTATOS.btngravarClick(Sender: TObject);
begin
    try
       begin
       if (nome.text='') or (template.text='') then
          begin
              application.MessageBox('Favor verificar se voc no deixou'+#13+'nome ou template em branco !!!!','Campo requerido no preenchido',+mb_iconerror);
              nome.Clear;
              nome.setfocus;
          end
          else
            begin
               dmdados.adotbcontatos.post;
               application.MessageBox('Operao concluda !!!','Gravao de dados',+mb_iconexclamation);
               travacontroles;
            end;
          end;
    except
       begin
           application.MessageBox('Houve um erro durante a gravao das informaes'+#13+'chame o suporte tcnico !!!','Erro de gravao',+mb_iconerror);
           dmdados.adotbcontatos.cancel;
           travacontroles;
       end;
    end;
end;

procedure TFRMCADCONTATOS.btnabortarClick(Sender: TObject);
begin
     dmdados.adotbcontatos.cancel;
     application.MessageBox('Operao cancelada !!!','Abortar Gravao de dados',+mb_iconexclamation);
     travacontroles;
end;

procedure TFRMCADCONTATOS.btnsairClick(Sender: TObject);
begin
     if application.messagebox('Confirma sada do sistema ?','Sair',+mb_yesno+mb_iconquestion)=idyes then
        begin
           frmcadcontatos.close;
           // Limpa a memria
           objIndexSearch.ClearDB;
           halt;
        end
     else
       begin
       end;
end;

procedure TFRMCADCONTATOS.spdbtnfirstClick(Sender: TObject);
begin
     dmdados.adotbcontatos.first;
end;

procedure TFRMCADCONTATOS.spdbtnpriorClick(Sender: TObject);
begin
     dmdados.adotbcontatos.prior;
end;

procedure TFRMCADCONTATOS.spdbtnnextClick(Sender: TObject);
begin
     dmdados.adotbcontatos.next;
end;

procedure TFRMCADCONTATOS.spdbtnlastClick(Sender: TObject);
begin
     dmdados.adotbcontatos.last;
end;

procedure TFRMCADCONTATOS.BtnRegisterClick(Sender: TObject);
var
        nUserID   : integer;
        szFir     : wideString;
begin
        nUserID := 0;

        if codigo.Text <> '' then
        begin
                nUserID := StrToInt(codigo.Text);

                // Get FIR data
                objDevice.Open(NBioAPI_DEVICE_ID_AUTO_DETECT) ;

                if objDevice.ErrorCode <> 0 Then
                        ShowMessage('Falha ao abrir o sensor biomtrico !');

                // Registra um novo TEMPLATE
                objExtraction.Enroll(nUserID, 0);
                template.Text := objExtraction.TextEncodeFIR;
                if objExtraction.ErrorCode <> NBioAPIERROR_NONE Then
                        ShowMessage('Registro falhou!');

                objDevice.Close(NBioAPI_DEVICE_ID_AUTO_DETECT);

                szFir := objExtraction.TextEncodeFIR;

                //Adciona na memria
                objIndexSearch.AddFIR(szFir, nUserID);

                if (objIndexSearch.ErrorCode = NBioAPIERROR_NONE) Then
                begin
                        ShowMessage('Impresso digital captura com sucesso!');
                end else
        end else
                ShowMessage('Please, input user id..');
end;
end.
